/****** Object:  View [dbo].[V_PAINEL_NFE_EST_PROD_TRANSF_ERRO_ANALITICO]    Script Date: 03/10/2018 11:00:00 ******/ 
IF EXISTS (SELECT * 
           FROM   SYS.VIEWS 
           WHERE  OBJECT_ID = 
      Object_id(N'[dbo].[V_PAINEL_NFE_EST_PROD_TRANSF_ERRO_ANALITICO]')) 
  DROP VIEW [dbo].[V_PAINEL_NFE_EST_PROD_TRANSF_ERRO_ANALITICO] 

GO 

--SELECT * FROM V_PAINEL_NFE_EST_PROD_TRANSF_ERRO_ANALITICO 
CREATE VIEW V_PAINEL_NFE_EST_PROD_TRANSF_ERRO_ANALITICO  
AS
SELECT RS.CD_FILIAL AS filialOrigemId,
       RS.CD_CTR AS numero,
       RS.DT_TRANSF AS dataTransferencia,
       RS.CD_FIL_DEST AS filialDestinoId,
       RS.FILIAL_DESTINO AS filialDestinoNome,
       RS.QT_SOL AS quantidadeSolicitada,
       RS.QT_AT AS quantidadeAtendida,
       RS.STATUS_RESSUPRIMENTO AS status,
       ERROS_VALIDACAO AS erro
FROM
  (SELECT EST_PROD_TRANSF.CD_EMP,
          EST_PROD_TRANSF.CD_FILIAL,
          EST_PROD_TRANSF.CD_CTR,
          EST_PROD_TRANSF.DT_TRANSF,
          EST_PROD_TRANSF.CD_FIL_DEST,
          NM_FANT AS FILIAL_DESTINO,
          SUM(ISNULL(EST_PROD_TRANSF_IT.QT_SOL, 0)) AS QT_SOL,
          SUM(CASE
                  WHEN EST_PROD_TRANSF.STS_TRANSF IN (0, 4) THEN 0
                  ELSE EST_PROD_TRANSF_IT.QT_AT
              END) AS QT_AT,
          CASE
              WHEN EST_PROD_TRANSF.STS_TRANSF = 0 THEN 'PENDENTE'
              WHEN EST_PROD_TRANSF.STS_TRANSF = 1 THEN 'PRE-FATURA'
              WHEN EST_PROD_TRANSF.STS_TRANSF = 2 THEN 'FATURADO'
              WHEN EST_PROD_TRANSF.STS_TRANSF = 3 THEN 'CHECKOUT FINALIZADO'
              WHEN EST_PROD_TRANSF.STS_TRANSF = 4 THEN 'CANCELADO'
              WHEN EST_PROD_TRANSF.STS_TRANSF = 5 THEN 'CHECKOUT INICIADO'
              WHEN EST_PROD_TRANSF.STS_TRANSF = 6 THEN 'SALDO PENDENTE'
              ELSE 'NAO DEFINIDO'
          END AS STATUS_RESSUPRIMENTO
   FROM EST_PROD_TRANSF
   INNER JOIN PRC_FILIAL ON EST_PROD_TRANSF.CD_EMP = PRC_FILIAL.CD_EMP
   AND EST_PROD_TRANSF.CD_FIL_DEST = PRC_FILIAL.CD_FILIAL
   LEFT JOIN EST_PROD_TRANSF_IT ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_IT.CD_EMP
   AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_IT.CD_FILIAL
   AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_IT.CD_CTR
   INNER JOIN EST_PROD_TRANSF_PENDENCIA ON EST_PROD_TRANSF.CD_EMP = EST_PROD_TRANSF_PENDENCIA.CD_EMP
   AND EST_PROD_TRANSF.CD_FILIAL = EST_PROD_TRANSF_PENDENCIA.CD_FILIAL
   AND EST_PROD_TRANSF.CD_CTR = EST_PROD_TRANSF_PENDENCIA.CD_CTR
   GROUP BY EST_PROD_TRANSF.CD_EMP,
            EST_PROD_TRANSF.CD_FILIAL,
            EST_PROD_TRANSF.CD_CTR,
            EST_PROD_TRANSF.CD_FIL_DEST,
            NM_FANT,
            EST_PROD_TRANSF.STS_TRANSF,
            EST_PROD_TRANSF.DT_TRANSF) RS
INNER JOIN EST_PROD_TRANSF_ERROS_VALIDACAO ON RS.CD_EMP = EST_PROD_TRANSF_ERROS_VALIDACAO.CD_EMP
AND RS.CD_FILIAL = EST_PROD_TRANSF_ERROS_VALIDACAO.CD_FILIAL
AND RS.CD_CTR = EST_PROD_TRANSF_ERROS_VALIDACAO.CD_CTR